# BeautifulSoup 获取所有p标签

获取所有p标签里的文本

```python
# -*- coding: UTF-8 -*-
from bs4 import BeautifulSoup

def fetch_p(html):
    # TODO(You): 请在此实现代码
    return results

if __name__ == '__main__':
    html = '''
        <html>
            <head>
                <title>这是一个简单的测试页面</title>
            </head>
            <body>
                <p class="item-0">body 元素的内容会显示在浏览器中。</p>
                <p class="item-1">title 元素的内容会显示在浏览器的标题栏中。</p>
            </body>
        </html>
        '''
    p_text = fetch_p(html)
    print(p_text)
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
from bs4 import BeautifulSoup


def fetch_p(html):
    soup = BeautifulSoup(html, 'lxml')
    p_list = soup.find_all("p")
    return [p.text for p in p_list]


def test():
    html = '''
        <html>
            <head>
                <title>这是一个简单的测试页面</title>
            </head>
            <body>
                <p class="item-0">body 元素的内容会显示在浏览器中。</p>
                <p class="item-1">title 元素的内容会显示在浏览器的标题栏中。</p>
            </body>
        </html>
        '''
    p_text = fetch_p(html)
    print(p_text)

if __name__ == '__main__':
    test()
```

## 答案

```python
def fetch_p(html):
    soup = BeautifulSoup(html, 'lxml')
    p_list = soup.find_all("p")
    results = [p.text for p in p_list]
    return results
```

## 选项

### A

```python
def fetch_p(html):
    soup = BeautifulSoup(html, 'lxml')
    p_list = soup.xpath("p")
    results = [p.text for p in p_list]
    return results
```

### B

```python
def fetch_p(html):
    soup = BeautifulSoup(html, 'lxml')
    p_list = soup.findAll("p")
    results = [p.text for p in p_list]
    return results
```

### C

```python
def fetch_p(html):
    soup = BeautifulSoup(html, 'lxml')
    results = soup.find_all("p")
    return results
```
